	function [Z0, RL, K] = RICHARDS_MF(N, Amax, Rs, Wc, Tau)
	
	% 	Computes the characteristic resistances in a doubly resistively
	% 	terminated Richards' structure with maximally flat passband with 
	%	equal terminating resistors, i.e., Rs = RL. Wc is the cutoff frequency 
	%	and Tau is the forward propagation time for the commensurate transmission line.	
 
	% 	Toolbox for  DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2007-07-02
	% 	Modified by: 	LW 2009-04-15, 2013-11-27
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		Works only for small bandwidths
	% 	Report bugs to:	Wanhammar@gmail.com
 
	epsilon = sqrt(10^(0.1*Amax)-1);
	n = 1:N;
	alfa = sin(Wc*Tau)*epsilon^(-1/N);
	beta = 2*sin((n-0.5)*pi/N)/alfa;
	gama = sin((n-1.5)*pi/N).*sin((n+0.5)*pi/N);
	Z0 = Rs*beta.*(1 - 0.25*cos(pi/N)*alfa^2./gama);
	for k = 1:2:N
		Z0(k) = Rs^2/Z0(k);
	end
	RL = Rs;
	K = 6*ones(1, N);
